/** window events **/

$(function() {

	// disable ajax query caching
	$.ajaxSetup({
		cache: false
	});

	checkSize();

	/**
	 * Manage dialog windows.
	 */
	window.parsed = false;
	$(window).on('hashchange', function() {
		windowParseUrl();
	});
	$(window).resize(function() {
		checkSize();
	});

	/**
	 * Show loading animation next to mouse cursor during any ajax request.
	 */
	$(document).ajaxStart(function() {
		//Spinner
		var opts = {
			segments: 12,
			steps: 3,
			//			opacity: 1.0,
			//			opacity: 0.7,
			opacity: 0.3,
			width: 4,
			space: 0,
			length: 5,
			trail: 50, // ?
			//			color: '#637a61',
			//                      color: '#26a61c',
			//                      color: '#637a61',
			//                      color: '#0e5708',
			//                      color: '#005500',
			//			color: '#637a61',
			color: '#70FF70',
			//                      color: '#fff',
			speed: 1.5
		};

		$('body').append('<div class="blockClicksOverlay" style="background-color: rgba(1, 1, 1, 0.0); bottom: 0; left: 0; position: fixed; right: 0; top: 0; z-index: 999999"></div>');
		$('button, input[type=\"button\"], input[type=\"submit\"], input[type=\"file\"]').attr('disabled', 'disabled');
		$("#ajax-loader").show();
		$("#ajax-loader").activity(opts);
	}).ajaxStop(function() {
		$('button, input[type=\"button\"], input[type=\"submit\"], input[type=\"file\"]').removeAttr('disabled');
		$('.blockClicksOverlay').remove();
		$("#ajax-loader").hide();
		$("#ajax-loader").activity(false);
	});
	$(document).mousemove(function(e) {
		$("#ajax-loader").css({
			left: e.pageX + 30,
			top: e.pageY + 30
		});
	});
});
